using System;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL.VAL.RPC
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stas Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>2/27/2005</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///		This class is used by the VistALink Windows Service TCP/IP Listener to collect 
	///		and return VBECS data to CPRS during the order entry process.
	///	</summary>

	#endregion

	public class OrderEntry : MarshalByRefObject
	{
		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/27/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6755"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>An instance of the class.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6756"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>NA.</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Default constructor.
		/// </summary>
		public OrderEntry()
		{
		}

		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="757"> 
		///		<ExpectedInput>valid PatientId from the Patient file and DivisionCode 589.</ExpectedInput>
		///		<ExpectedOutput>XML string with patient dfn, firstName, lastName, ssn, abo, and rh data elements.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="981"> 
		///		<ExpectedInput>null vistaPatientID</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5958"> 
		///		<ExpectedInput>null divisionCode</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6037"> 
		///		<ExpectedInput>Valid VistaPatientId from the Patient table and division code
		///		with transfusion reaction history</ExpectedInput>
		///		<ExpectedOutput>xml string containing transfusion reactions.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6038"> 
		///		<ExpectedInput>Valid VistaPatientId from the Patient table and division code
		///		with Antibody history</ExpectedInput>
		///		<ExpectedOutput>xml string containing antibody history.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6039"> 
		///		<ExpectedInput>Valid VistaPatientId from the Patient table and division code
		///		with autologous units identified</ExpectedInput>
		///		<ExpectedOutput>xml string containing autologous units.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6040"> 
		///		<ExpectedInput>Valid VistaPatientId from the Patient table and division code
		///		with directed units identified</ExpectedInput>
		///		<ExpectedOutput>xml string containing directed units.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6041"> 
		///		<ExpectedInput>Valid VistaPatientId from the Patient table and division code
		///		with crossmatched units identified</ExpectedInput>
		///		<ExpectedOutput>xml string containing crossmatched units.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6042"> 
		///		<ExpectedInput>Valid VistaPatientId from the Patient table and division code
		///		with assigned units identified</ExpectedInput>
		///		<ExpectedOutput>xml string containing assigned units.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6043"> 
		///		<ExpectedInput>Valid VistaPatientId from the Patient table and division code
		///		with an available specimen identified.</ExpectedInput>
		///		<ExpectedOutput>xml string containing an available specimen.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6044"> 
		///		<ExpectedInput>Valid VistaPatientId from the Patient table and division code
		///		with component related specimen requirements.</ExpectedInput>
		///		<ExpectedOutput>xml string containing specimen requirements for a component.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6045"> 
		///		<ExpectedInput>Valid VistaPatientId from the Patient table and division code
		///		with component related lab test result requirements.</ExpectedInput>
		///		<ExpectedOutput>xml string containing lab test result requirements for a component.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="0" testid ="6046"> 
		///		<ExpectedInput>Valid VistaPatientId from the Patient table and division code
		///		with component related MSBOS requirements for pre-op orders.</ExpectedInput>
		///		<ExpectedOutput>xml string containing msbos requirements for a component.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6047"> 
		///		<ExpectedInput>Valid VistaPatientId from the Patient table and division code
		///		with a list of Surgery names for use with pre-op orders.</ExpectedInput>
		///		<ExpectedOutput>xml string containing surgery names.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// This method is called through VistALink by CPRS to retrieve Order Entry information
		/// prior to creating an order in CPRS.
		/// Implements BR_40.14
		/// </summary>
		/// <param name="vistaPatientID">VistA Patient file (#2) Internal Entry Number</param>
		/// <param name="divisionCode">VistA Station Number form the Institution file (#4)</param>
		/// <returns>XML string of data used by CPRS Order Entry of VBECS requests.</returns>
		public string GetBloodBankOrderData(string vistaPatientID, string divisionCode)
		{
			if( (vistaPatientID == string.Empty) || (vistaPatientID == null) )
				throw( new ArgumentNullException( "vistaPatientID" ) );

			if( (divisionCode == string.Empty) || (divisionCode == null) )
				throw( new ArgumentNullException( "vistaPatientID" ) );

			SqlParameter[] _prms =
			{
				// CR 2431 changed vistaPatientId to Bigint.
				new SqlParameter(STOREDPROC.VistaGetXmlBloodBankData.VistAPatientId ,SqlDbType.BigInt),
				new SqlParameter(STOREDPROC.VistaGetXmlBloodBankData.DivisionCode, SqlDbType.Char, 5)
			};
			_prms[0].Value = vistaPatientID;
			_prms[1].Value = divisionCode;

			return RpcDataReader.GetXmlData(STOREDPROC.VistaGetXmlBloodBankData.StoredProcName, _prms);
		}
	}
}
